<?php

namespace Bloom\CMS\Core\Framework\Commands;

use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\HPV\Praticiens\PraticiensServiceProvider;
use Bloom\CMS\HPV\Specialites\SpecialitesServiceProvider;
use Bloom\CMS\Modules\Actu\Model\Actu;
use Illuminate\Console\Command;

class PageCorrect extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'page:correct';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Associe les pages Actus / Praticiens / Spécialités à leurs dossiers respectifs';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        //Actualités
        $dossier_actus = Dossier::where('type', '=', Actu::class)->first();
        $actus = Page::where('contenu_type', '=', 'actus')
            ->where('dossier_id', '<>', $dossier_actus->id)
            ->get();

        foreach ($actus as $actu) {
            $actu->dossier_id = $dossier_actus->id;
            $actu->save();
        }

        //Praticiens
        $dossier_praticiens = Dossier::where('name', '=', PraticiensServiceProvider::DOSSIER_NAME)->first();
        $praticiens = Page::where('contenu_type', '=', 'praticiens')
            ->where('dossier_id', '<>', $dossier_praticiens->id)
            ->get();

        foreach ($praticiens as $praticien) {
            $praticien->dossier_id = $dossier_praticiens->id;
            $praticien->save();
        }

        //Spécialités
        $dossier_specialites = Dossier::where('name', '=', SpecialitesServiceProvider::DOSSIER_NAME)->first();
        $specialites = Page::where('contenu_type', '=', 'specialites')
            ->where('dossier_id', '<>', $dossier_specialites->id)
            ->get();

        foreach ($specialites as $specialite) {
            $specialite->dossier_id = $dossier_specialites->id;
            $specialite->save();
        }
    }
}
