<?php
/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Bloom\CMS\Core\Http\Page;
use Faker\Generator as Faker;
use Illuminate\Database\Eloquent\Factory;

$factory->define(Page::class, function (Faker $faker) {
    $slug = $faker->slug;

    return [
        'meta_titre'       => $faker->text(191),
        'meta_description' => $faker->text(191),
        'titre'            => $faker->text(191),
        'slug'             => $slug,
        'pathname'         => $slug,
        'multiplicity'     => '1',
        'statut_id'        => 1
    ];
});


$factory->state(Page::class, 'index', [
    'is_index' => 1,
    'slug'     => ''
]);

$factory->state(Page::class, 'unpublished', [
    'statut_id' => \Bloom\CMS\Core\Contenus\Statut::EN_COURS,
]);
