<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangementRelationPageContenu extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::dropIfExists('page_contenus');

        Schema::table('pages', function (Blueprint $table) {
            $table->string('contenu_type')->default('');
            $table->integer('contenu_id', false, true)->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::create('page_contenus', function (Blueprint $table) {
            $table->id();
            $table->integer('page_id', false, true);
            $table->integer('contenu_id', false, true);
            $table->string('contenu_type');
            $table->boolean('en_suppression')->default(0);
            $table->boolean('en_ajout')->default(1);
            $table->boolean('actif')->default(0);
            $table->timestamps();
        });

        Schema::table('pages', function (Blueprint $table) {
            $table->dropColumn('contenu_type');
            $table->dropColumn('contenu_id');
        });
    }
}
