<?php

namespace Bloom\Model;

/**
 * Relationship model
 */
class Relationship
{
    /**
     * @var string
     */
    protected $database_correspondence;
    /**
     * @var string
     */
    protected $end_property;
    /**
     * @var string
     */
    public $property;

    /**
     * @var \Bloom\Model\Base
     */
    public $class;
    /**
     * Can the target browse the parent
     * @var boolean
     */
    protected $navigable;

    /**
     * @var boolean
     */
    protected $oneToMany;

    protected $correspondence_table;
    protected $parentColumn;
    protected $childColumn;
    protected $moreWhere;
    protected $parentCorrespondence;

    /**
     * Relationship constructor.
     * @param string $property
     * @param string $class
     */
    public function __construct($property, $class)
    {
        $this->property = $property;
        $this->class = $class;
        $this->end_property = strtolower((new \ReflectionClass($class))->getShortName());
        $this->database_correspondence = $property.'_id';
        $this->parentCorrespondence = 'id';
        $this->navigable = true;
        $this->oneToMany = true;
    }

    /**
     * @return $this
     */
    public function OneToMany()
    {
        $this->oneToMany = true;
        return $this;
    }

    /**
     * @return $this
     */
    public function OneToOne()
    {
        $this->oneToMany = false;
        return $this;
    }

    /**
     * @param string $table
     * @param string $parentColumn
     * @param string $childColumn
     * @return $this
     */
    public function correspondenceTable($table, $parentColumn, $childColumn) {
        $this->correspondence_table = $table;
        $this->parentColumn = $parentColumn;
        $this->childColumn = $childColumn;
        return $this;
    }

    /**
     * @param $database_correspondence
     * @return $this
     */
    public function setDatabaseCorrespondence($database_correspondence)
    {
        $this->database_correspondence = $database_correspondence;
        return $this;
    }

    /**
     * @param $end_property
     * @return $this
     */
    public function setEndProperty($end_property)
    {
        $this->end_property = $end_property;
        return $this;
    }

    /**
     * @return $this
     */
    public function noNavigable()
    {
        $this->navigable = false;
        return $this;
    }

    /**
     * @return $this
     */
    public function setNavigable()
    {
        $this->navigable = true;
        return $this;
    }

    /**
     * Add an additional condition when makeItHappen will fetch the child
     * @param $where
     * @return $this
     */
    public function additionalWhere($where)
    {
        $this->moreWhere = $where;
        return $this;
    }

    /**
     * Make it happen :D
     * @param Model $parent
     * @param \PDO
     */
    public function makeItHappen(Model $parent,\PDO $database = null)
    {
        $class = $this->class;
        if($this->oneToMany) {
            if($this->correspondence_table === null) {
                $parent->{$this->property} = $class::getItems(
                    [
                        [
                            'column'=>$this->database_correspondence,
                            'operator'=>'=',
                            'value'=>$parent->{$this->parentCorrespondence}
                        ]
                    ]
                );
            } else {
                if($database === null) {
                    return;
                }
                $parent->{$this->property} = [];
                foreach($database->query('SELECT * FROM '.$this->correspondence_table.' WHERE '.$this->parentColumn.' = '.$parent->{$this->parentCorrespondence}.($this->moreWhere !== null ? ' AND '.$this->moreWhere:'')) as $row) {
                    $item = $class::getItem([[
                        'column'=>'id',
                        'operator'=>'=',
                        'value'=>$row[$this->childColumn]
                    ]]);
                    if($this->navigable) {
                        $item->{$this->end_property} = $parent;
                    }
                    $parent->{$this->property}[] = $item;
                }
            }
        } else {
            if($this->correspondence_table === null) {
                if($this->moreWhere === null) {
                    $item =  $class::getItem(
                        [
                            [
                                'column'=>$this->database_correspondence,
                                'operator'=>'=',
                                'value'=>$parent->{$this->parentCorrespondence}
                            ]
                        ]
                    );
                } else {
                    $item = $database->query('SELECT id FROM '.$class::getTable().' WHERE '.$this->parentColumn.'='.$parent->{$this->parentCorrespondence}.' AND '.$this->moreWhere)->fetchObject($class);
                }
            } else {
                if($this->moreWhere === null) {
                    $item =  $class::getItem(
                        [
                            [
                                'column'=>'id',
                                'operator'=>'=',
                                'value'=> $database->query('SELECT '.$this->childColumn.' FROM'.$this->correspondence_table.' WHERE '.$this->parentColumn.'='.$parent->{$this->parentCorrespondence})->fetchColumn()
                            ]
                        ]
                    );
                } else {
                    $item = $class::getItem([
                        [
                            'column'=>'id',
                            'operator'=>'=',
                            'value'=>$database->query('SELECT '.$this->childColumn.' FROM '.$this->correspondence_table.' WHERE '.$this->parentColumn.'='.$parent->{$this->parentCorrespondence}.' AND '.$this->moreWhere)->fetchColumn()
                        ]
                    ]);
                }
            }
            if($item === false) {
                $item = new $class();
            }
            $parent->{$this->property} = $item;
            if($this->navigable)
            {
                $parent->{$this->property}->{$this->end_property} = $parent;
            }
        }
    }

    /**
     * @param string $parentCorrespondence
     * @return $this
     */
    public function setParentCorrespondence($parentCorrespondence)
    {
        $this->parentCorrespondence = $parentCorrespondence;
        return $this;
    }
}
