<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 26/04/2016
 * Time: 12:07
 */

namespace Bloom\Database;


class Database extends \Slim\PDO\Database
{
    /**
     * @var callable
     */
    protected $onBeforeExecuteHandler;
    /**
     * @var callable
     */
    protected $onAfterExecuteHandler;
    /**
     * @var callable
     */
    protected $onFetchHandler;

    /**
     * @return array
     */
    protected function getDefaultOptions()
    {
        return array(
            \PDO::ATTR_ERRMODE => \PDO::ERRMODE_EXCEPTION,
            \PDO::ATTR_DEFAULT_FETCH_MODE => \PDO::FETCH_ASSOC,
            \PDO::ATTR_EMULATE_PREPARES => false,
            \PDO::ATTR_STATEMENT_CLASS => array('Bloom\\Database\\Statement', array($this)),
        );
    }

    public function __construct($dsn, $usr = null, $pwd = null, array $options = array())
    {
        parent::__construct($dsn, $usr, $pwd, $options);
    }

    public function onBeforeExecute(callable $handler)
    {
        $this->onBeforeExecuteHandler = $handler;
    }

    public function onAfterExecute(callable $handler)
    {
        $this->onAfterExecuteHandler = $handler;
    }

    public function onFetch(callable $handler)
    {
        $this->onFetchHandler = $handler;
    }

    /**
     * @param string $event
     * @param array $args
     * @return mixed
     */
    public function fire($event, array $args = [])
    {
        $handler = 'on' . ucfirst($event) . 'Handler';
        if ($this->{$handler} !== null) {
            return call_user_func_array($this->{$handler}, $args);
        }
        return;
    }

    public function exec($statement)
    {
        $this->fire('beforeExecute', [$statement]);
        $return = parent::exec($statement);
        $this->fire('afterExecute', [$statement]);
        return $return;
    }

}
