<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 09/03/2016
 * Time: 15:20
 */

namespace Bloom\Controller;


use Bloom\Controller\Request\Input;
use Bloom\Controller\Request\Request;
use Bloom\Singleton;

abstract class Controller {
    /**
     * @var Input
     */
    protected $input;
    /**
     * @var Request
     */
    protected $request;
    use Singleton;

    protected function __construct()
    {
        $this->input = Input::getInstance();
        $this->request = Request::getInstance();
    }

    public function isPost()
    {
        return $_SERVER['REQUEST_METHOD'] === 'POST';
    }

    public function isGet()
    {
        return $_SERVER['REQUEST_METHOD'] === 'GET';
    }

    public function __call($name, $arguments)
    {
        if(preg_match('/^is(\w+)/', $name, $matches)) {
            return $_SERVER['REQUEST_METHOD'] === strtoupper($matches[1]);
        }
        return null;
    }

    public function execute() {
        if($this->request->get('action') === null) {
            return $this->index();
        } else {
            return $this->{$this->request->get('action')}();
        }
    }

    abstract public function index();
}