<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 13/01/2016
 * Time: 14:06
 */

namespace Bloom;


class Configuration
{
    use Singleton;

    protected $haveSection = true;

    /**
     * @var array
     */
    protected $conf;

    /**
     * @var string
     */
    protected $file;

    protected function __construct($file = null)
    {
        $this->file = $file;
        $this->loadConf();
    }

    /**
     * @throws LoadingError when we can not load the configuration file
     */
    protected function loadConf()
    {
        if($this->file !== null) {
            if(!file_exists($this->file)) {
                throw new LoadingError('File '.$this->file.' does not exist');
            }
            $this->conf = parse_ini_file($this->file, $this->haveSection);
            if($this->conf === false) {
                $error = error_get_last();
                throw new LoadingError($error['message']);
            }
        }
    }

    public function __get($name) {
        return static::get($name);
    }

    public static function get($param, $section = '') {
        $intstance = static::getInstance();
        if($intstance->haveSection) {
            if(array_key_exists($section,$intstance->conf) && array_key_exists($param, $intstance->conf[$section])) {
                return $intstance->conf[$section][$param];
            }
            if($section === '' && array_key_exists($param, $intstance->conf[array_keys($intstance->conf)[0]])) {
                return $intstance->conf[array_keys($intstance->conf)[0]][$param];
            }
        } else {
            if(array_key_exists($param,$intstance->conf)) {
                return $intstance->conf[$param];
            }
        }
        return null;
    }

    public function HaveSection()
    {
        $this->haveSection = true;
        $this->loadConf();
        return $this;
    }

    public function NoSection()
    {
        $this->haveSection = false;
        $this->loadConf();
        return $this;
    }

    public function SetFile($file)
    {
        $this->file = $file.'.ini';
        $this->loadConf();
        return $this;
    }

    public static function Reload()
    {
        static::getInstance()->loadConf();
    }
}