<?php

/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 26/10/2016
 * Time: 12:45
 */
class ConfigurationTest extends PHPUnit_Framework_TestCase
{
    public function getFiles()
    {
        return [
            [
                DATASET_PATH . '/configuration/dumy-with-section',
                [
                    'ORIGINAL' => [
                        'SECTIONA' => ['dummyA' => 'foo'],
                        'SECTIONB' => ['dummyA' => 'bar']
                    ],
                    'OVERIDE' => [
                        'SECTIONA' => ['dummyA' => 'baz']
                    ]
                ]
            ],
            [
                DATASET_PATH . '/configuration/dumy',
                [
                    'ORIGINAL' => [
                        'dummyA' => 'foo',
                        'dummyB' => 'bar'
                    ],
                    'OVERIDE' => [
                        'dummyA' => 'baz'
                    ]
                ]
            ]
        ];
    }

    /**
     * @dataProvider getFiles
     * @param string $file
     * @param array $dataset
     */
    public function test_load_file($file,array $dataset)
    {
        \Bloom\Configuration::getInstance()->SetFile($file);
        static::assertAttributeEquals($dataset['ORIGINAL'], 'conf', \Bloom\Configuration::getInstance());
        static::assertAttributeEquals($dataset['OVERIDE'], 'override', \Bloom\Configuration::getInstance());
    }
}
