<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 26/04/2016
 * Time: 12:15
 */

namespace Bloom\Database;


use PHPUnit_Extensions_Database_DataSet_IDataSet;
use PHPUnit_Extensions_Database_DB_IDatabaseConnection;

class DatabaseTest extends \PHPUnit_Extensions_Database_TestCase
{

    public function test_event_triggering()
    {
        $connection = $this->getConnection();
        $data = $connection->createDataSet();
        /**
         * @var Database $a
         */
        $a = $connection->getConnection();
        $b = false;
        $a->onBeforeExecute(function($query, $input) use (&$b) {
            $b = true;
        });

        $a->select()->from($data->getTableNames()[0])->execute()->rowCount();

        static::assertTrue($b);
    }

    /**
     * Returns the test database connection.
     *
     * @return PHPUnit_Extensions_Database_DB_IDatabaseConnection
     */
    protected function getConnection()
    {
        $pdo = new Database('sqlite::memory:');
        return $this->createDefaultDBConnection($pdo, ':memory:');
    }

    /**
     * Returns the test dataset.
     *
     * @return PHPUnit_Extensions_Database_DataSet_IDataSet
     */
    protected function getDataSet()
    {
        return $this->createFlatXMLDataSet(DATASET_PATH.'/simple.xml');
    }
}
