<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 26/04/2016
 * Time: 12:08
 */

namespace Bloom\Database;

use PDO;

class Statement extends \Slim\PDO\Statement
{
    /**
     * @var \Bloom\Database\Database
     */
    protected $dbh;

    public function execute($bound_input_params = null)
    {
        $this->dbh->fire('beforeExecute', [$this->queryString, $bound_input_params]);
        $return = parent::execute($bound_input_params);
        $this->dbh->fire('afterExecute', [$this->queryString, $bound_input_params, $return]);
        return $return;
    }

    public function fetch($fetch_style = null, $cursor_orientation = PDO::FETCH_ORI_NEXT, $cursor_offset = 0)
    {
        $fetch = parent::fetch($fetch_style, $cursor_orientation, $cursor_offset);
        $this->dbh->fire('fetch', [$fetch,$fetch_style, $cursor_orientation, $cursor_offset]);
        return $fetch;
    }

    protected function __construct(Database $dbh)
    {
        parent::__construct($dbh);
    }
}
