<?php
/**
 * Created by IntelliJ IDEA.
 * User: bloom
 * Date: 04/02/2016
 * Time: 14:27
 */

namespace Bloom\System;


use Bloom\Error\InvalidOptionError;

class Csv
{
    const OPT_NONE = 0;
    const OPT_LOAD_ON = 1;
    const OPT_SAVE_ON_BROWSE = 2;
    const OPT_NO_DELIMITER = 4;

    /**
     * @var resource
     */
    protected $resource;
    /**
     * @var string
     */
    protected $file;
    /**
     * @var string
     */
    protected $mode;
    protected $head;
    protected $data;
    protected $all;
    protected $end;
    protected $option;

    public function __construct($file, $mode, $option = 0)
    {
        $this->file = $file;
        $this->mode = $mode;
        $this->end = false;
        $this->all = [];
        $this->option = $option;
        $this->open();
        if(($option & static::OPT_LOAD_ON) === static::OPT_LOAD_ON) {
            $this->next();
            while($this->current())
            {
                $this->next();
            }
        }
    }

    public function getData() {
        if(($this->option & static::OPT_LOAD_ON) === static::OPT_LOAD_ON || ($this->option & static::OPT_SAVE_ON_BROWSE) === static::OPT_SAVE_ON_BROWSE) {
            return $this->data;
        }
        throw new InvalidOptionError('Option Csv::OPT_LOAD_ON or Csv::OPT_SAVE_ON_BROWSE must be ON');
    }

    protected function open()
    {
        $this->resource = fopen($this->file, $this->mode);
        $this->head = $this->getLine();
    }

    /**
     * @param $index
     * @return array
     */
    public function get($index) {
        if(!is_array($this->all)) {
            return;
        }
        return $this->all[$index];
    }

    /**
     * @return array
     */
    public function current()
    {
        return !$this->end?$this->data:false;
    }

    public function next()
    {
        $this->data = [];
        if($line = $this->getLine()) {
            foreach ($line as $k=>$item) {
                $this->data[$this->head[$k]] = utf8_encode($item);
            }
            if(($this->option & static::OPT_SAVE_ON_BROWSE) === static::OPT_SAVE_ON_BROWSE) {
                $this->all[] = $this->data;
            }
        } else {
            $this->end = true;
        }
    }

    public function find($col, $val)
    {
        $items = [];
        foreach ($this->all as $item) {
            if($item[$col] === $val) {
                $items[] = $item;
            }
        }
        return $items;
    }

    protected function getLine()
    {
        if(($this->option & static::OPT_NO_DELIMITER) === static::OPT_NO_DELIMITER) {
            $line = fgetcsv($this->resource,null, ';', '');
        } else {
            $line = fgetcsv($this->resource,null, ';', '"');
        }
        if($line !== [null]) {
            return $this->encode($line);
        }
        return $this->getLine();
    }

    public function __destruct()
    {
        fclose($this->resource);
    }

    protected function encode(array $values)
    {
        foreach($values as &$value) {
            $value = mb_convert_encoding($value, 'UTF-8');
        }
        return $values;
    }
}