<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 10/06/2016
 * Time: 15:11
 */

namespace Bloom\Geometry;

/**
 * Class Point
 * @package Geometry
 */
class Point
{
    /**
     * @var float
     */
    public $x;
    /**
     * @var float
     */
    public $y;

    /**
     * Point constructor.
     * @param float $x
     * @param float $y
     */
    public function __construct($x, $y)
    {
        $this->x = $x;
        $this->y = $y;
    }

    public function distance(Point $point)
    {
        return pow( pow(abs($point->x - $this->x), 2) + pow(abs($point->y - $this->y), 2) , 0.5 );
    }
}
