<?php
/**
 * Created by IntelliJ IDEA.
 * User: Loïc Rameau
 * Date: 09/03/2016
 * Time: 15:21
 */

namespace Bloom\Controller\Request;


use Bloom\Singleton;

class Request
{
    use Singleton;
    protected $data;

    protected function __construct()
    {
        $this->reload();
    }

    public function get($param, $default = null, $method = null)
    {
        if ($method !== null) {
            return $this->data['get'][$param] ?: $default;
        }
        if (array_key_exists($param, $this->data['get'])) {
            return $this->data['get'][$param];
        }
        if (array_key_exists($param, $this->data['post'])) {
            return $this->data['post'][$param];
        }
        return $default;
    }

    public function getData()
    {
        return $this->data;
    }

    public function reload()
    {
        $this->data['get'] = $_GET;
        $this->data['post'] = $_POST;
    }
}